<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Mail;

final class PhpMailMailer implements Mailer
{
    public function send(string $to, string $subject, string $textBody, ?string $htmlBody = null, array $headers = []): bool
    {
        $boundary = 'sb-' . bin2hex(random_bytes(8));
        $eol = "\r\n";
        $hdrLines = [];
        foreach ($headers as $name => $value) {
            $name = trim((string) $name);
            $value = trim((string) $value);
            if ($name === '' || $value === '') continue;
            $hdrLines[] = $name . ': ' . $value;
        }

        if ($htmlBody !== null && $htmlBody !== '') {
            $hdrLines[] = 'MIME-Version: 1.0';
            $hdrLines[] = 'Content-Type: multipart/alternative; boundary="' . $boundary . '"';
            $body  = '--' . $boundary . $eol;
            $body .= 'Content-Type: text/plain; charset="utf-8"' . $eol . $eol;
            $body .= $textBody . $eol;
            $body .= '--' . $boundary . $eol;
            $body .= 'Content-Type: text/html; charset="utf-8"' . $eol . $eol;
            $body .= $htmlBody . $eol;
            $body .= '--' . $boundary . '--' . $eol;
        } else {
            $hdrLines[] = 'MIME-Version: 1.0';
            $hdrLines[] = 'Content-Type: text/plain; charset="utf-8"';
            $body = $textBody;
        }

        $headersStr = implode($eol, $hdrLines);
        // @ to avoid warnings on mutualized hosting if mail() is disabled
        return @mail($to, $subject, $body, $headersStr);
    }
}

