<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Persistence;

use PDO;
use Skyboard\Domain\Rules\RuleDefinition;
use Skyboard\Domain\Rules\RuleDictionary;
use Skyboard\Domain\Rules\RulesProvider;
final class MySqlRulesProvider implements RulesProvider
{
    public function __construct(
        private readonly DatabaseConnection $connection,
        private readonly ?RuleDictionary $dictionary = null
    ) {
    }

    public function forContext(string $boardId, string $actorId): array
    {
        $stmt = $this->connection->pdo()->prepare('SELECT id, scope, priority, triggers_json, conditions_json, actions_json, on_veto_json FROM board_rules WHERE board_id = :boardId');
        $stmt->execute(['boardId' => $boardId]);
        $rules = [];
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $definition = new RuleDefinition(
                'board:' . $boardId . ':' . md5((string) ($row['triggers_json'] ?? '') . (string) ($row['actions_json'] ?? '')),
                (string) ($row['scope'] ?? 'board'),
                (int) ($row['priority'] ?? 0),
                json_decode((string) ($row['triggers_json'] ?? '[]'), true) ?? [],
                json_decode((string) ($row['conditions_json'] ?? '[]'), true) ?? [],
                json_decode((string) ($row['actions_json'] ?? '[]'), true) ?? [],
                isset($row['on_veto_json']) && $row['on_veto_json'] !== null ? json_decode((string) $row['on_veto_json'], true) : null,
                'db:board_rules',
                null
            );
            $rules[] = $definition;
            if ($this->dictionary !== null) {
                $this->dictionary->registerDefinition($definition);
            }
        }
        return $rules;
    }
}
