<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Persistence;

use PDO;
use Skyboard\Application\Services\UserRepository;
final class MySqlUserRepository implements UserRepository
{
    public function __construct(private readonly DatabaseConnection $connection)
    {
    }

    public function findByEmail(string $email): ?array
    {
        $stmt = $this->connection->pdo()->prepare('SELECT u.*, p.pseudo, p.role FROM users u LEFT JOIN user_profiles p ON p.user_id = u.id WHERE u.email = :email');
        $stmt->execute(['email' => strtolower($email)]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public function findById(int $id): ?array
    {
        $stmt = $this->connection->pdo()->prepare('SELECT u.*, p.pseudo, p.role FROM users u LEFT JOIN user_profiles p ON p.user_id = u.id WHERE u.id = :id');
        $stmt->execute(['id' => $id]);
        $row = $stmt->fetch(PDO::FETCH_ASSOC);
        return $row ?: null;
    }

    public function create(string $email, string $passwordHash): int
    {
        $stmt = $this->connection->pdo()->prepare('INSERT INTO users(email, password_hash, created_at) VALUES(:email, :hash, :created)');
        $stmt->execute([
            'email' => strtolower($email),
            'hash' => $passwordHash,
            'created' => time(),
        ]);
        $userId = (int) $this->connection->pdo()->lastInsertId();

        $profileStmt = $this->connection->pdo()->prepare(
            'INSERT INTO user_profiles(user_id, pseudo, role)
             VALUES(:user, :pseudo, :role)
             ON DUPLICATE KEY UPDATE pseudo = VALUES(pseudo), role = VALUES(role)'
        );
        $profileStmt->execute([
            'user' => $userId,
            'pseudo' => null,
            'role' => 'standard',
        ]);

        return $userId;
    }
}
