<?php

declare(strict_types=1);

namespace Skyboard\Infrastructure\Rules;

use Skyboard\Domain\Rules\RuleDefinition;

final class RuleFileLoader
{
    /** @return list<RuleDefinition> */
    public static function load(string $file, string $scope, string $source): array
    {
        if (!file_exists($file)) {
            return [];
        }

        $content = file_get_contents($file);
        if ($content === false) {
            return [];
        }

        // Support JSON et PHP
        if (str_ends_with($file, '.json')) {
            $data = json_decode($content, true);
            if (!is_array($data)) {
                return [];
            }
        } elseif (str_ends_with($file, '.php')) {
            $data = include $file;
            if (!is_array($data)) {
                return [];
            }
        } else {
            return [];
        }

        $rules = [];
        foreach ($data as $ruleData) {
            if (!is_array($ruleData) || !isset($ruleData['id'])) {
                continue;
            }

            $rules[] = new RuleDefinition(
                (string) $ruleData['id'],
                $scope,
                (int) ($ruleData['priority'] ?? 0),
                (array) ($ruleData['triggers'] ?? []),
                (array) ($ruleData['conditions'] ?? []),
                (array) ($ruleData['actions'] ?? []),
                isset($ruleData['on_veto']) ? (array) $ruleData['on_veto'] : null,
                $source,
                isset($ruleData['description'])
                    ? (string) $ruleData['description']
                    : (isset($ruleData['explain']) ? (string) $ruleData['explain'] : null)
            );
        }

        return $rules;
    }
}
