<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers\Admin;

use Skyboard\Application\Services\Admin\SecurityAdminService;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class SecurityAdminController
{
    use AdminControllerTrait;

    public function __construct(private readonly SecurityAdminService $security)
    {
    }

    public function ipList(Request $request): Response
    {
        if ($response = $this->requireAdmin($request)) {
            return $response;
        }

        return Response::ok(['ips' => $this->security->ipRecords()]);
    }

    public function clearIp(Request $request): Response
    {
        if ($response = $this->requireAdmin($request)) {
            return $response;
        }

        $ip = (string) ($request->body['ip'] ?? '');
        if ($ip === '') {
            return Response::error('INVALID_PAYLOAD', 'Paramètre ip requis.', [], 422);
        }

        $this->security->clearIp($ip);
        return Response::ok(['result' => 'cleared']);
    }

    public function clearAll(Request $request): Response
    {
        if ($response = $this->requireAdmin($request)) {
            return $response;
        }

        $this->security->clearAllIps();
        return Response::ok(['result' => 'cleared']);
    }

    public function resetSchema(Request $request): Response
    {
        if ($response = $this->requireAdmin($request)) {
            return $response;
        }

        $this->security->resetSchema();
        return Response::ok(['result' => 'reset']);
    }
}
