<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Controllers;

use Skyboard\Domain\Rules\RuleDictionary;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class RulesExplainController
{
    public function __construct(
        private readonly RuleDictionary $dictionary,
        private readonly bool $exposed
    ) {
    }

    public function explain(Request $request): Response
    {
        if (!$this->exposed) {
            return Response::error('NOT_FOUND', 'Ressource introuvable.', [], 404);
        }

        $reasonId = trim((string) ($request->query['reasonId'] ?? ''));
        if ($reasonId === '') {
            return Response::error('INVALID_PAYLOAD', 'Paramètre reasonId requis.', [], 422);
        }

        $message = $this->dictionary->explain($reasonId);

        return Response::ok([
            'reasonId' => $reasonId,
            'message' => $message,
        ]);
    }

    public function index(Request $request): Response
    {
        if (!$this->exposed) {
            return Response::error('NOT_FOUND', 'Ressource introuvable.', [], 404);
        }

        return Response::ok([
            'rules' => $this->dictionary->all(),
        ]);
    }
}
