<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Middleware;

use Closure;
use Skyboard\Application\Services\UserRepository;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;
use Skyboard\Infrastructure\Security\SessionManager;

final class AuthMiddleware
{
    public function __construct(
        private readonly SessionManager $sessions,
        private readonly UserRepository $users
    ) {
    }

    public function __invoke(Request $request, Closure $next): Response
    {
        $token = $request->cookies['sb_session'] ?? null;
        if (!$token) {
            $authHeader = $request->headers['Authorization'] ?? $request->headers['authorization'] ?? null;
            if ($authHeader && str_starts_with($authHeader, 'Bearer ')) {
                $token = substr($authHeader, 7);
            }
        }
        if ($token) {
            $session = $this->sessions->get($token);
            if ($session) {
                $user = $this->users->findById((int) $session['user_id']);
                if ($user) {
                    $request = $request->withAttribute('session', $session)->withAttribute('user', $user);
                }
            }
        }
        return $next($request);
    }
}

