<?php

declare(strict_types=1);

namespace Skyboard\Interfaces\Http\Middleware;

use Closure;
use Skyboard\Infrastructure\Http\Request;
use Skyboard\Infrastructure\Http\Response;

final class CsrfMiddleware
{
    public function __invoke(Request $request, Closure $next): Response
    {
        $bypass = ['/api/auth/login', '/api/auth/register'];
        if (!in_array($request->method, ['GET', 'HEAD', 'OPTIONS'], true) && !in_array($request->path, $bypass, true)) {
            $session = $request->getAttribute('session');
            if (!$session) {
                return Response::error('CSRF_SESSION_REQUIRED', 'Session requise pour valider la requête.', [], 401);
            }
            // Read CSRF header case-insensitively to accommodate server-specific casing
            $token = null;
            foreach ($request->headers as $name => $value) {
                if (strtolower((string) $name) === 'x-csrf-token') {
                    $token = (string) $value;
                    break;
                }
            }
            if (!$token || !hash_equals($session['csrf_token'], (string) $token)) {
                return Response::error('CSRF_TOKEN_INVALID', 'Jeton CSRF invalide ou manquant.', [], 403);
            }
        }
        return $next($request);
    }
}
