#!/bin/sh
set -e
TARGETS=""
for dir in src public docs; do
  if [ -d "$dir" ]; then
    TARGETS="$TARGETS $dir"
  fi
done
if [ -z "$(echo "$TARGETS" | tr -d ' ')" ]; then
  exit 0
fi
FORBIDDEN_WORD=$(printf '\x69\x6e\x62\x6f\x78')
PATTERN="\\b${FORBIDDEN_WORD}\\b"
if grep -RInw --exclude-dir=.git --exclude='*CHANGELOG*' -E "$PATTERN" $TARGETS; then
  echo "Found forbidden term" >&2
  exit 1
fi
